<?php

if (!defined('ABSPATH')) exit;

class ACE_WebP_Frontend
{
    public function __construct()
    {
        if (defined('REST_REQUEST') && REST_REQUEST) return;
        if (defined('DOING_CRON') && DOING_CRON) return;
        if (defined('XMLRPC_REQUEST') && XMLRPC_REQUEST) return;
        if (!$this->browser_supports_webp()) return;

        add_action('template_redirect', [$this, 'start_buffer']);
    }

    public function start_buffer(): void
    {
        ob_start([$this, 'rewrite_html']);
    }

    /**
     * Rewrite image URLs in the final HTML output.
     */
    public function rewrite_html(string $html): string
    {
        if (empty($html)) return $html;

        $upload_dir  = wp_upload_dir();
        $upload_url  = preg_quote($upload_dir['baseurl'], '#');
        $upload_path = $upload_dir['basedir'];

        // Strip <script> blocks to avoid rewriting URLs inside JS.
        $scripts = [];
        $html = preg_replace_callback(
            '#<script[^>]*>.*?</script>#si',
            function (array $m) use (&$scripts): string {
                $key = '<!--ACEWEBP_SCRIPT_' . count($scripts) . '-->';
                $scripts[$key] = $m[0];
                return $key;
            },
            $html
        );

        // Match jpg/jpeg/png URLs inside wp-content/uploads.
        $pattern = '#(' . $upload_url . '/[^\s\'"<>?#]+\.(?:jpe?g|png))#i';

        $base_url  = $upload_dir['baseurl'];
        $base_path = $upload_path;

        $html = preg_replace_callback($pattern, function (array $m) use ($base_url, $base_path): string {
            $url      = $m[1];
            $relative = substr($url, strlen($base_url));
            $file     = $base_path . $relative;
            $webp     = $file . '.webp';

            if (file_exists($webp)) {
                return $url . '.webp';
            }

            return $url;
        }, $html);

        // Restore <script> blocks.
        if ($scripts) {
            $html = str_replace(array_keys($scripts), array_values($scripts), $html);
        }

        return $html;
    }

    private function browser_supports_webp(): bool
    {
        return isset($_SERVER['HTTP_ACCEPT'])
            && str_contains($_SERVER['HTTP_ACCEPT'], 'image/webp');
    }
}
